#!/bin/bash

VERSION_DIR=/opt/afe/bin

currentVersion="" #This version variable should not have a v but should contain all other characters ex Github release tag is v1.2.4 currentVersion is 1.2.4

SERVER_BASE_URL=https://geely.mywire.org
TEMP_UPDATE_DIR=$(mktemp -d)
ARCHIVE_NAME=update.tar.gz

arch=$(uname -m)
if [[ $arch == x86_64* ]]; then
    ARCH_PATH=amd64
elif  [[ $arch == armv7* ]]; then
    ARCH_PATH=armv7
elif  [[ $arch == aarch64* ]]; then
    ARCH_PATH=aarch64 
fi


## This function determines which http get tool the system has installed and returns an error if there isnt one
getConfiguredClient()
{
  if  command -v curl &>/dev/null; then
    configuredClient="curl"
  elif command -v wget &>/dev/null; then
    configuredClient="wget"
  elif command -v http &>/dev/null; then
    configuredClient="httpie"
  elif command -v fetch &>/dev/null; then
    configuredClient="fetch"
  else
    echo "Error: This tool reqires either curl, wget, httpie or fetch to be installed\." >&2
    return 1
  fi
}

## Allows to call the users configured client without if statements everywhere
httpGet()
{
  case "$configuredClient" in
    curl)  curl -A curl -s "$@" ;;
    wget)  wget -qO- "$@" ;;
    httpie) http -b GET "$@" ;;
    fetch) fetch -q "$@" ;;
  esac
}

update()
{
if [[ $currentVersion == "" || $latestVersion == "" ]];then
  echo "Error: update utility has not been configured correctly." >&2
  return 1
else
  if [[ $latestVersion != $currentVersion ]]; then
    echo "Version $latestVersion available"
    cd ${TEMP_UPDATE_DIR}
    URL=${SERVER_BASE_URL}/${latestVersion}/${ARCH_PATH}/${ARCHIVE_NAME}
    echo "Downloading ${URL}"
    httpGet ${URL} > ${ARCHIVE_NAME} || { echo "Couldn't download latest version" ; return 1; }
    tar -xzf ${ARCHIVE_NAME} || { echo "Couldn't unarchive latest version" ; return 1; }
    
    /bin/bash "${TEMP_UPDATE_DIR}/install.sh" || { echo "Couldn't install latest version" ; return 1; }
    
    rm -r -f "${TEMP_UPDATE_DIR}" || { echo "Error: successfully updated but couldn't delete temperary files at ${TEMP_UPDATE_DIR}"; return 1; }
  else
    echo "$currentVersion is already the latest version"
  fi
fi
}

checkInternet()
{
  httpGet google.com > /dev/null 2>&1 || { echo "Error: no active internet connection" >&2; return 1; } # query google with a get request
}


getConfiguredClient || exit 1
checkInternet || exit 1
currentVersion=$(cat "${VERSION_DIR}"/version.txt) || currentVersion="1"
latestVersion=$(httpGet ${SERVER_BASE_URL}/versions.txt | head -1 )  #always grabs the tag without the v option
update || exit 1